DROP PROCEDURE [hips].[IhiLookupAuditInsert]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Gordon Massey
-- Create date: 11 Oct 2012
-- Description:   Inserts a new record into the IhiLookupAlert Table
-- =============================================
CREATE PROCEDURE [hips].[IhiLookupAuditInsert] 
(
	@PatientMasterId INT,
	@IhiNumber VARCHAR(50) = NULL,
	@IhiStatus INT,
	@IhiRecordStatus INT,
	@FamilyName VARCHAR(80),
	@GivenName VARCHAR(80),
	@SexId INT,
	@DateOfBirth DATETIME,
	@MedicareNumber VARCHAR(12)=NULL,
	@DvaNumber VARCHAR(18)=NULL,
	@Message VARCHAR(200)=NULL,
	@HpiI VARCHAR(16)=NULL,
	@HpiO VARCHAR(16),
	@Operator VARCHAR(100),
	@Request XML=NULL,
	@Response XML=NULL,
	@UserModified varchar(256)
)
AS
BEGIN
    SET NOCOUNT ON
	
    DECLARE @intErrorCode INT
		,@IhiLookupAuditId INT
		 , @LastSequenceNumber INT = 0

    SET @intErrorCode = 0
    
    SELECT TOP 1 @LastSequenceNumber = SequenceNumber
	FROM [hips].[IhiLookupAudit]
	WHERE PatientMasterID = @PatientMasterID
	ORDER BY SequenceNumber DESC


    INSERT
     INTO [hips].IhiLookupAudit
             ( PatientMasterId ,
               SequenceNumber ,
               IhiNumber ,
               IhiStatus ,
               IhiRecordStatus ,
               FamilyName ,
               GivenName ,
               SexId ,
               DateOfBirth ,
               MedicareNumber ,
               DvaNumber ,
               Message ,
               HpiI ,
               HpiO ,
               Operator ,
               Request ,
               Response ,
               DateCreated ,
               UserCreated ,
               DateModified ,
               UserModified
             )
     VALUES  ( @PatientMasterId , -- PatientMasterId - int
               @LastSequenceNumber + 1 , -- SequenceNumber - int
               @IhiNumber , -- IhiNumber - varchar(50)
               @IhiStatus , -- IhiStatus - int
               @IhiRecordStatus , -- IhiRecordStatus - int
               @FamilyName , -- FamilyName - varchar(80)
               @GivenName , -- GivenName - varchar(80)
               @SexId , -- SexId - int
               @DateOfBirth , -- DateOfBirth - datetime
               @MedicareNumber , -- MedicareNumber - varchar(12)
               @DvaNumber , -- DvaNumber - varchar(18)
               @Message , -- Message - varchar(200)
               @HpiI , -- HpiI - varchar(16)
               @HpiO , -- HpiO - varchar(16)
               @Operator , -- Operator - varchar(100)
               @Request , -- Request - xml
               @Response , -- Response - xml
               GETDATE() , -- DateCreated - datetime
               @UserModified , -- UserCreated - varchar(256)
               GETDATE() , -- DateModified - datetime
               @UserModified  -- UserModified - varchar(256)
             )
    SELECT @intErrorCode = @@ERROR 
		, @IhiLookupAuditId = SCOPE_IDENTITY()
    IF @intErrorCode = 0
    BEGIN
        SELECT [IhiLookupAuditId],
		 PatientMasterId ,
               SequenceNumber ,
               IhiNumber ,
               IhiStatus ,
               IhiRecordStatus ,
               FamilyName ,
               GivenName ,
               SexId ,
               DateOfBirth ,
               MedicareNumber ,
               DvaNumber ,
               Message ,
               HpiI ,
               HpiO ,
               Operator ,
               Request ,
               Response ,
               DateCreated ,
               UserCreated ,
               DateModified ,
               UserModified
         FROM [hips].[IhiLookupAudit]
         WHERE [IhiLookupAuditId] = @IhiLookupAuditId
    END

    RETURN(@intErrorCode)
END
GO

